s        ;   N m  0(                                       bp9714                          Burster Process Interface Type 9714                                                                   F      Instrument Name: burster Process Interface
                   Type 9714

  Description:   This instrument module provides
                 RS232, RS485 (fullduplex only)
                 support for Process Interface
                 Type 9714 from burster.

  Functions and Classes:

  (1) Initialize :
      Initialize the instrument

  (2) Calibrate:
      Calibrate functions of the Process Interface

  (3) Calculate:
      Calculate settings of the instrument

  (4) Configure:
      Configures the instrument

  (5) Measuring :
      Measuring functions of the Process Interface

  (6) Peak Detection:
      Peak Detection functions of the Process
      Interface

  (7) Tare :
      Tare functions of the Process Interface

  (8) System Serial Communication
      Change the Communication Parameters
      of the instrument

  (9) System:
      Display Contrast
      Reads the system error
      Reads the instrument ID-String
      Controls the keyboard
      Sends a SCPI-Message
      Receives a SCPI-Message

  (10) Close :
      Takes the instrument off-line.
      *********
          Class Name:    Initialize

 Description:   Sets up all necessary functions
                for Initialize the seriall inter-
                face     u     Class Name:    Calibrate

 Description:   Sets up all necessary functions
                for Calibrate the device     u     Class Name:    Configure

 Description:   Sets up all necessary functions
                for Configure the device     w     Class Name:    Comparator

 Description:   Sets up all necessary comparator
                functions for the device     s     Class Name:    Peak Detection

 Description:   Set up all peak detection
                functions of the device     j     Class Name:    Tare

 Description:   Sets up all necessary Tare
                functions of the device     }     Class Name:    Measuring

 Description:   Sets up all necessary functions
                for mesuring with the Digistant.          Class Name:    System Serial Communicate

 Description:   Sets up all necessary system
                serial Commnicated functions
                of the 9714
     l     Class Name:    System

 Description:   Sets up all necessary system
                functions of the 9714    x     Panel Name:    Initialize One Device

 Description:   Initializes the instrument by:
 1) finding an unused device in the device table
    using the supplied serial group and user
    address
 2) device clear and RESET  (if desired)
 3) returns the ID-String of the instrument
 4) returns an instrument ID

Defaults : 8  Data Bits
           1  Stop Bit
           No Partiy         Control Name:   COM-Port

 Description:    Specifies the COM-Port to be
                 used to communicate with the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1 - COM1   (=> Adress 0x3f8 IRQ4)
                 2 - COM2   (=> Adress 0x2f8 IRQ3)
                 3 - COM3   (=> Adress 0x3e8 IRQ4)
                 4 - COM4   (=> Adress 0x2e8 IRQ3)

 Default:        1         Control Name:   Baud Rate

 Description:    Specifies the baud rate of the
                 RS232-Port to communicate with
                 the instrument. This value must
                 correspond to the current
                 internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1200,2400,4800,9600 or 19200 baud

 Default:        9600    *     Control Name:   Time-out (seconds)

 Description:    Specifies  the time-out limit for
                 I/O operations.
                 A  value  of  0.0  will  disable
                 time-out altogether.

 Variable Type:  Double

 Valid Range:    0.060 to 100.0 seconds

 Default:        1.0    q     Control Name:   Bcc-Check

 Description:    This parameter switches the block
                 check function of the driver ON
                 or OFF.
                 This value must correspond to the
                 current internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF    |     Control Name:  Group Address

 Description:   Specifies the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.
                This value must correspond to the
                current internal group address
                from the instrument.


 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0    w     Control Name:  User Adress

 Description:   Specifies the user address on the
                RS232 (RS485) to be used to
                communicate with the instrument.
                This value must correspond to the
                current internal user address
                from the instrument.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0          Control Name:  Instrument ID String

 Description:   Returns the ID-String of the
                instrument.

 Variable Type: String

    *     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.
          Control Name:  Reset

 Description:   If reset is on, a device clear and
 power on reset is done during initialization.

 Variable Type: Integer

 Valid Range:   0 to 1
                0 = off
                1 = on
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   COM-Port is out of range
       -2   Baud Rate is out of range
       -3   Time-out is out of range
       -4   Block Check parameter is out of range
       -5   Group Address is out of range
       -6   User Address is out of range
       -7   Reset Device is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    @  >           COM-Port                                      Baud Rate                         d     `    Time-out (seconds)                           Block Check                              `    Group Address                            `    User Address                            `    Instrument ID-String                    `    Instrument ID                                Reset Device                           `    Error                                         1 1 2 2 3 3 4 4              @1200 1200 2400 2400 4800 4800 9600 9600 19200 19200 38400 38400    2.0    On 1 Off 0    0    0    	            	           On 1 Off 0    	                Panel Name:    Initialize All Devices

 Description:   Search all connected devices
 Initializes the instrument by:
 1) finding an unused device in the device table
    using the supplied seriall group and user
    address
 2) returns an Array of instrument ID's
 3) returns an Array of Group and User Addresses

 4) During to search the connected Instruments
    return the function the Code 360, after the
    search is finshed, the function return 0

C  Example:

  ret = 1;
  while (ret != 0)
   bp9714_init_all_devices(...);

         Control Name:   COM-Port

 Description:    Specifies the COM-Port to be
                 used to communicate with the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1 - COM1   (=> Adress 0x3f8 IRQ4)
                 2 - COM2   (=> Adress 0x2f8 IRQ3)
                 3 - COM3   (=> Adress 0x3e8 IRQ4)
                 4 - COM4   (=> Adress 0x2e8 IRQ3)

 Default:        1         Control Name:   Baud Rate

 Description:    Specifies the baud rate of the
                 RS232-Port to communicate with
                 the instrument. This value must
                 correspond to the current
                 internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1200,2400,4800,9600 or 19200 baud

 Default:        9600    *     Control Name:   Time-out (seconds)

 Description:    Specifies  the time-out limit for
                 I/O operations.
                 A  value  of  0.0  will  disable
                 time-out altogether.

 Variable Type:  Double

 Valid Range:    0.060 to 100.0 seconds

 Default:        1.0    q     Control Name:   Bcc-Check

 Description:    This parameter switches the block
                 check function of the driver ON
                 or OFF.
                 This value must correspond to the
                 current internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF          Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID-Array, which is
 used as an input here.
 (The ID is used to select among like-instruments)

 Variable Type: Integer Arraqy



          Control Name:  Group Addresses

 Description:   The initialize function call
 returns an Group Address Array, which is
 used as an input here.

 Variable Type: Integer Array

          Control Name:  User Addresses

 Description:   The initialize function call
 returns an User Address Array, which is
 used as an input here.

 Variable Type: Integer Array          Control Name:  Instr. Numbers

 Description:   The initialize function call
                returns the number of founded
                instruments

 Variable Type: Integer         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   COM-Port is out of range
       -2   Baud Rate is out of range
       -3   Time-out is out of range
       -4   Block Check parameter is out of range
       -5   Group Address is out of range
       -6   User Address is out of range
       -7   Reset Device is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      360   The function sends Code 360 during
            to search the instruments
    t  >           COM-Port                          !            Baud Rate                         "     `    Time-out (seconds)                #           Block Check                       %C      `    Instrument ID                     &1      `    Group Addresses                   &     `    User Addresses                    '      `    Instr Numbers                     (Z     `    Error                                         1 1 2 2 3 3 4 4              @1200 1200 2400 2400 4800 4800 9600 9600 19200 19200 38400 38400    2.0    On 1 Off 0    	            	            	            	            	                 Panel Name:    Initialize RS485 (CVI only)

 Description:   This function is usefull in
                LabWindows/CVI only, because the
                RS485 Halfduplex Mode is only
                supported in CVI/V3.1
         Control Name:   RS485 Ctrl. Bit State

 Description:    This parameter switches the Ctrl.
                 Bit RTS or DTR from the RS485
                 halfduplex Ctrl

 Variable Type:  Integer

 Valid Values:   0 = RTS
                 1 = DTR

 Default:        0 = RTS    .     Control Name:   Ctrl. Bit State

 Description:    This parameter switches the state
                 from the RS485 halfduplex Ctrl.
                 Bit Low or High Active.

 Variable Type:  Integer

 Valid Values:   0 = Low Active
                 1 = High Active

 Default:        1 = High Active          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Ctrl Bit
       -2   Invalid Ctrl State
    / m            RS485 Ctrl. Bit                   1 mG          Ctrl. Bit State                   2P     `    Error                              DTR 1 RTS 0   High Active 1 Low Active 0    	            V     Panel Name:    Calibration State

 Description:   Sets the calibration State ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the calibration
                functions are possible to activate

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    4e        `    Instrument ID                     5 a          State                             6e     `    Error                              1    On 1 Off 0    	            P     Panel Name:    Calibration State

 Description:   Reads the calibration state    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the calibration
                functions are possible to activate

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    :e        `    Instrument ID                     ; m    `    State                             <e    `    Error                              1    	            	            R     Panel Name:    Sets Calibration Unit

 Description:   Set the Calibration Unit
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Unit

 Description:   This parameter selects the
                calibration unit

 Variable Type: Integer

 Valid Range:   0 = mV
                1 = mV/V         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Calibration Unit

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    @e        `    Instrument ID                     A m          Calibration Unit                  BK     `    Error                              1    mV/V 1 mV 0    	            T     Panel Name:    Read Calibration Unit

 Description:   Reads the Calibration Unit
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Unit

 Description:   This parameter selects the
                calibration unit

 Variable Type: Integer

 Valid Range:   0 = mV
                1 = mV/V         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Calibration Unit

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    F[        `    Instrument ID                     G n      `    Calibration Unit                  HA     `    Error                              1    	            	                Panel Name:    Calibrate Input

 Description:   Calibrate the instrument in
                following ways:

                - Input the Calibration low and
                  high Value
                - Input the Scale low and
                  high Value    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Low Cal. Value

 Description:   Specifies the low calibration
                value

 Variable Type: Double

 Default:       0.0          Control Name:  High Cal. Value

 Description:   Specifies the high calibration
                value

 Variable Type: Double

 Default:       0.0     }     Control Name:  Low Scale value

 Description:   Specifies the low scale value

 Variable Type: Double

 Default:       0.0          Control Name:  High Scale Value

 Description:   Specifies the high Scale Value

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    L        `    Instrument ID                     N.      `    Low Cal. Value                    N     `    High Cal. Value                   Od }     `    Low Scale Value                   O }    `    High Scale Value                  Pp     `    Error                              1    0.0    0.0    0.0    0.0    	                Panel Name:    Read Calibration Input

 Description:   Reads the calibration data of the 
                the input:

                - Reads the Calibration low and
                  high Value
                - Reads the Scale low and
                  high Value    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Low Cal. Value

 Description:   Specifies the low calibration
                value

 Variable Type: Double

 Default:       0.0          Control Name:  High Cal. Value

 Description:   Specifies the high calibration
                value

 Variable Type: Double

 Default:       0.0     }     Control Name:  Low Scale value

 Description:   Specifies the low scale value

 Variable Type: Double

 Default:       0.0          Control Name:  High Scale Value

 Description:   Specifies the high Scale Value

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    U        `    Instrument ID                     V      `    Low Cal. Value                    W     `    High Cal. Value                   X& }     `    Low Scale Value                   X }    `    High Scale Value                  Y2     `    Error                              1    	           	           	           	           	                 Panel Name:    Calibrate Analogue Output

 Description:   Calibrate the instrument in
                following ways:

                - Calibrate the low and
                  high value of the analogue
                  Output    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Low  Value

 Description:   Specifies the low calibration
                value of the analogue output

 Variable Type: Double

 Default:       0.0          Control Name:  High Value

 Description:   Specifies the high calibration
                value of the analogue output

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    ^p        `    Instrument ID                     _ m     `    Low Value                         `N mG    `    High Value                        `     `    Error                                `    Low_Scale                        G    `    High_Scale                         1    0.0    0.0    	            0.0    0.0        Panel Name:    Read Calibration Analogue Output

 Description:   Reads the Calibration data of the analoque
                output:

                - Reads the low and high output values
                  and the low and high scale values
                      )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Low  Value

 Description:   Specifies the low calibration
                value of the analogue output

 Variable Type: Double

 Default:       0.0          Control Name:  High Value

 Description:   Specifies the high calibration
                value of the analogue output

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    fD        `    Instrument ID                     gu m     `    Low Value                         h" mE    `    High Value                        h    `    Error                                 `    Low_Scale                        E    `    High_Scale                         1    	           	           	            	           	           n     Panel Name:    Calibrate Input Meas

 Description:   Start to measure the calibration
                value    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Measure

 Description:   This parameter starts to measure
                the calibration Value

 Variable Type: Integer

 Valid Range:   0 = Low Value
                1 = High Value         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Measure

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    m        `    Instrument ID                     n m           Measure                           o     `    Error                              1    High Value 1 Low Value 0    	                 Panel Name:    Read Calibration Input Meas

 Description:   Reads the measured values Kal1 and Kal2
                of the input calibration    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Measure

 Description:   This parameter starts to measure
                the calibration Value

 Variable Type: Integer

 Valid Range:   0 = Low Value
                1 = High Value         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Measure

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    s        `    Instrument ID                     u a     `    Kal1                              u     `    Error                            b=    `    Kal2                               1    	           	            	                Panel Name:    Accept calibration datas

 Description:   The calibration values from
                followed function are accept

                - Calibration Input /Meas.
                - Calibration Analog Output
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   The devicve don't accept the
            calibration datas    z        `    Instrument ID                     {     `    Error                              1    	           T     Panel Name:    Config Device

 Description:   Configure the instrument in
                following ways:

                - Selects the device of the device
                - Selects the Display Format
                - Sets the Average Counts
                - Selects the Average Control
                - Selects the measurement mode    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Average Control

 Description:   This parameter selects the type of
                Averaging

 Variable Type: Integer

 Valid Range:   0 = Moving
                1 = Repeat          Control Name:  Average Counts

 Description:   This parameter inputs the numbers
                of average counts

 Variable Type: Integer

 Valid Range:   1 - 9999          Control Name:  Measurement Mode

 Description:   This parameter is meant for
                changing between single and
                repetition measurements.

 Variable Type: Integer

 Valid Range:   0 = Single
                1 = Repetition          Control Name:  Display Format

 Description:   This parameter selects the display
                Format

 Variable Type: Integer

 Valid Range:   0 - 6          Control Name:  Device Unit

 Description:   This parameter selects the display
                Format

 Variable Type: Integer

 Valid Range:   0 - 6    w     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Average Control
       -3   Invalid Average Counts
       -4   Invalid Measurement Mode
       -5   Invalid Display Format
       -6   Invalid Device Unit

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Measurement Mode

 Description:   This parameter is meant for
                changing between single and
                repetition measurements.

 Variable Type: Integer

 Valid Range:   0 = Single
                1 = Repetition            `    Instrument ID                                 Average Control                         `    Average Counts                    z y           Measurement Mode                  z }3          Display Format                     }        Device Unit                            `    Error                             <            Start Mode                         1    Repeat 1 Moving 0    1    Repetition 1 Single 0               FXXXXXX. 0 XXXXX.X 1 XXXX.XX 2 XXX.XXX 3 XX.XXXX 4 X.XXXXX 5 .XXXXXX 6            +  mN 0  N 1 kN 2 MN 3 mg 4 g 5 kg 6 t 7 mNm 8 Ncm 9 Nm 10 kNm 11 MNm 12 m 13 mm 14 cm 15 dm 16 m 17 inch 18 mil 19 cm/S^2 20 m/s^2 21 mbar 22 bar 23 kbar 24 Pa 25 hPa 26 kPa 27 MPa 28 GPa 29 PSI 30 kPSI 31 grd 32 rad 33 gon 34 V 35 mV 36 V 37 A 39 mA 40 A 41 kA 42 mV/V 43    	            Auto 1 Stop 0   b     Panel Name:    Read Config Device

 Description:   Reads the Configuration of the 
                instrument in following ways:

                - Reads the unit of the device
                - Reads the display format
                - Reads the average counts
                - Reads the average control
                - Reads the measurement mode    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Average Control

 Description:   This parameter selects the type of
                Averaging

 Variable Type: Integer

 Valid Range:   0 = Moving
                1 = Repeat          Control Name:  Average Counts

 Description:   This parameter inputs the numbers
                of average counts

 Variable Type: Integer

 Valid Range:   1 - 9999          Control Name:  Measurement Mode

 Description:   This parameter is meant for
                changing between single and
                repetition measurements.

 Variable Type: Integer

 Valid Range:   0 = Single
                1 = Repetition          Control Name:  Display Format

 Description:   This parameter selects the display
                Format

 Variable Type: Integer

 Valid Range:   0 - 6          Control Name:  Device Unit

 Description:   This parameter selects the display
                Format

 Variable Type: Integer

 Valid Range:   0 - 6    w     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Average Control
       -3   Invalid Average Counts
       -4   Invalid Measurement Mode
       -5   Invalid Display Format
       -6   Invalid Device Unit

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  Measurement Mode

 Description:   This parameter is meant for
                changing between single and
                repetition measurements.

 Variable Type: Integer

 Valid Range:   0 = Single
                1 = Repetition            `    Instrument ID                     J       `    Average Control                         `    Average Counts                     }     `    Measurement Mode                         `    Display Format                    d }    `    Device Unit                            `    Error                                   `    Start mode                         1    	            	            	            	            	            	            	           	     Panel Name:    Config Output Supply

 Description:   Configure the instrument in
                following ways:

                - Selects the type of the supply
                - Selects the shape of the supply
                - Selects the value of the supply    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    -     Control Name:   Output Shape

 Description:    This parameter switches the
                 shapee mode of the device

 Variable Type:  Integer

 Valid Values:   0 = DC
                 1 = LOW
                 2 = DCR
                 3 = ACR
                 4 = ALTR

 Default:        0 = Intern    p     Control Name:   Output Supply

 Description:    This parameter switches the
                 Output Value of the device

 Variable Type:  Integer

 Valid Values:   0 = Asym. 2.5V
                 1 = Asym. 5V
                 2 = Asym. 10V
                 3 = Sym.  5V
                 4 = Sym.  10V
                 5 = Sym.  20V


 Default:        0 = Asym. 2.5V         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Output Shape
       -3   Invalid Output Type
       -3   Invalid Output Supply Value


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

            `    Instrument ID                      m           Output Shape                       m}          Output Supply                     s     `    Error                              1               DC 0 LOW 1 DCR 2 ACR 3 ALTR 4               NAsym. 2.5V 0 Asym.   5V 1 Asym.  10V 2 Sym.    5V 3 Sym.   10V 4 Sym.   20V 5    	           ?     Panel Name:    Read Config Output 

 Description:   Reads the configuration of the
                instrument excitation output in
                following way:

                - Reads the type of the excitation
                - Reads the shape of the excitation
                - Reads the value of the exitation    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    -     Control Name:   Output Shape

 Description:    This parameter switches the
                 shapee mode of the device

 Variable Type:  Integer

 Valid Values:   0 = DC
                 1 = LOW
                 2 = DCR
                 3 = ACR
                 4 = ALTR

 Default:        0 = Intern    p     Control Name:   Output Supply

 Description:    This parameter switches the
                 Output Value of the device

 Variable Type:  Integer

 Valid Values:   0 = Asym. 2.5V
                 1 = Asym. 5V
                 2 = Asym. 10V
                 3 = Sym.  5V
                 4 = Sym.  10V
                 5 = Sym.  20V


 Default:        0 = Asym. 2.5V         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Output Shape
       -3   Invalid Output Type
       -3   Invalid Output Supply Value


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    8        `    Instrument ID                     i m      `    Output Shape                       m}     `    Output Supply                      }    `    Error                              1    	            	            	                 Panel Name:    Config Analog Output

 Description:   Configure the instrument in
                following ways:

                - Selects the analog output type    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    
     Control Name:   Analogue Output Type

 Description:    This parameter switches the
                 Analogue Output type of the
                 device

 Variable Type:  Integer

 Valid Values:   0 = Current
                 1 = Voltage

 Default:        0 = Current         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Anlogue Output type


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

            `    Instrument ID                       m           Analog Output Type                     `    Error                              1    Voltage 1 Current 0    	            }     Panel Name:    Read Config Analog Output

 Description:   Reads the analoque output type of
                the instrument    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    
     Control Name:   Analogue Output Type

 Description:    This parameter switches the
                 Analogue Output type of the
                 device

 Variable Type:  Integer

 Valid Values:   0 = Current
                 1 = Voltage

 Default:        0 = Current         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Anlogue Output type


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    /        `    Instrument ID                     ` m      `    Analog Output Type                u     `    Error                              1    	            	           &     Panel Name:    Config Intput

 Description:   Configure the instrument in
                following ways:

                - Selects the reference point of
                  the sensor input
                - Switch the input low pass-filter
                - Selects the input voltage range    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Reference Point

 Description:    This parameter switches the
                 intput Reference Point
                 of the device

 Variable Type:  Integer

 Valid Values:   0 = Grounded
                 1 = Difference

          Control Name:   Input Filter

 Description:    This parameter switches the
                 intput low-pass Filter
                 of the device

 Variable Type:  Integer

 Valid Values:   0 = Off
                 1 = On

    [     Control Name:   Voltage Range

 Description:    This parameter switches the
                 input Voltage Range of the device

 Variable Type:  Integer

 Valid Values:   0 = 1.25mV
                 1 = 2.5mV
                 2 = 5mV
                 3 = 10mV
                 4 = 12.5mV
                 5 = 25mV
                 6 = 50mV
                 7 = 100mV
                 8 = 125mV
                 9 = 250mV
                10 = 500mV
                11 = 1V
                12 = 1.25V
                13 = 2.5V
                14 = 5V
                15 = 10V
                16 = 12V

    )     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Reference Point
       -3   Invalid Filter
       -4   Invalid Voltage Range


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
    -        `    Instrument ID                     ^ m           Reference Point                   X m          Input Filter                      B m        Voltage Range                          `    Error                              1    Difference 1 Grounded 0    On 1 Off 0               1.25mV 0 2.5mV 1 5mV 2 10mV 3 12.5mV 4 25mV 5 50mV 6 100mV 7 125mV 8 250mV 9 500mV 10 1V 11 1.25V 12 2.5V 13 5V 14 10V 15 12V 16    	           q     Panel Name:    Read Config Intput

 Description:   Reads the configuration of the
                instruments input in the following
                ways:

                - Reads the reference point of
                  the sensor input
                - Reads the state of the input low
                  pass-filter
                - Reads the input voltage range    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Reference Point

 Description:    This parameter switches the
                 intput Reference Point
                 of the device

 Variable Type:  Integer

 Valid Values:   0 = Grounded
                 1 = Difference

          Control Name:   Input Filter

 Description:    This parameter switches the
                 intput low-pass Filter
                 of the device

 Variable Type:  Integer

 Valid Values:   0 = Off
                 1 = On

    [     Control Name:   Voltage Range

 Description:    This parameter switches the
                 input Voltage Range of the device

 Variable Type:  Integer

 Valid Values:   0 = 1.25mV
                 1 = 2.5mV
                 2 = 5mV
                 3 = 10mV
                 4 = 12.5mV
                 5 = 25mV
                 6 = 50mV
                 7 = 100mV
                 8 = 125mV
                 9 = 250mV
                10 = 500mV
                11 = 1V
                12 = 1.25V
                13 = 2.5V
                14 = 5V
                15 = 10V
                16 = 12V

    )     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Reference Point
       -3   Invalid Filter
       -4   Invalid Voltage Range


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
    "        `    Instrument ID                     S m      `    Reference Point                   M m     `    Input Filter                      7 p    `    Voltage Range                     ̚     `    Error                              1    	            	            	            	            T     Panel Name:    Comparator State

 Description:   Sets the Comparator State ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    e        `    Instrument ID                     Җ m          State                             K     `    Error                              1    On 1 Off 0    	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    O        `    Instrument ID                     ؀ m     `    State                             5     `    Error                              1    	            	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    7        `    Instrument ID                     h m     `    Count                                  `    Error                              1    	            	                 Panel Name:    Comparator Config

 Description:   Configure the comparator functions
                of the instrument in following
                ways:

                - Selects the comparator type
                - Selects the comparator Control    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Comparator Type

 Description:   Switches the comparator type


 Variable Type: Integer

 Default:       0 = Dynamic

 Valid Range:   0 = Dynamic
                1 = Static          Control Name:  Comparator Control

 Description:   Switches the comparator Control


 Variable Type: Integer

 Default:       0 = Single

 Valid Range:   0 = Single
                1 = Average
                2 = Minimum
                3 = Maximum         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Comparator Type
       -3   Invalid Comparator Control

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

            `    Instrument ID                      m           Comparator Type                    m          Comparator Control                     `    Error                              1    Static 1 Dynamic 0               'Single 0 Average 1 Minimum 2 Maximum 3    	                 Panel Name:    Comparator Config

 Description:   Configure the comparator functions
                of the instrument in following
                ways:

                - Selects the comparator type
                - Selects the comparator Control    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Comparator Type

 Description:   Switches the comparator type


 Variable Type: Integer

 Default:       0 = Dynamic

 Valid Range:   0 = Dynamic
                1 = Static          Control Name:  Comparator Control

 Description:   Switches the comparator Control


 Variable Type: Integer

 Default:       0 = Single

 Valid Range:   0 = Single
                1 = Average
                2 = Minimum
                3 = Maximum         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Comparator Type
       -3   Invalid Comparator Control

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

            `    Instrument ID                     B m      `    Comparator Type                    o     `    Comparator Control                     `    Error                              1    	            	            	            t     Panel Name:    Two Limit Comparator

 Description:   Configure the two limit comparator
                functions    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Lower Limit

 Description:   Specifies the lower limit of the
                two limit comparator

 Variable Type: Double

 Default:       0.0          Control Name:  Upper Limit

 Description:   Specifies the upper limit of the
                two limit comparator

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas            `    Instrument ID                      m     `    Lower Limit                       y mG    `    Upper Limit                       "     `    Error                              1    0.0    0.0    	                 Panel Name:    Read Two Limit Comparator

 Description:   Reads the configuration of the
                two limit comparator.
                    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Lower Limit

 Description:   Specifies the lower limit of the
                two limit comparator

 Variable Type: Double

 Default:       0.0          Control Name:  Upper Limit

 Description:   Specifies the upper limit of the
                two limit comparator

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas            `    Instrument ID                      m     `    Lower Limit                       ~ mG    `    Upper Limit                       '     `    Error                              1    	           	           	            v     Panel Name:    Four Limit Comparator

 Description:   Configure the four limit
                comparator functions    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Lower Limit 1

 Description:   Specifies the lower limit of the
                two limit comparator 1

 Variable Type: Double

 Default:       0.0          Control Name:  Upper Limit1

 Description:   Specifies the upper limit of the
                two limit comparator 1

 Variable Type: Double

 Default:       0.0          Control Name:  Lower Limit 2

 Description:   Specifies the lower limit of the
                two limit comparator 2

 Variable Type: Double

 Default:       0.0          Control Name:  Upper Limit2

 Description:   Specifies the upper limit of the
                two limit comparator 2

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas           `    Instrument ID                          `    Lower Limit1                     u     `    Upper Limit1                     ! m     `    Lower Limit2                      m    `    Upper Limit2                     z     `    Error                              1    0.0    0.0    0.0    0.0    	                 Panel Name:    Read Four Limit Comparator

 Description:   Reads the configuration of the four
                limit comparator functions    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Lower Limit 1

 Description:   Specifies the lower limit of the
                two limit comparator 1

 Variable Type: Double

 Default:       0.0          Control Name:  Upper Limit1

 Description:   Specifies the upper limit of the
                two limit comparator 1

 Variable Type: Double

 Default:       0.0          Control Name:  Lower Limit 2

 Description:   Specifies the lower limit of the
                two limit comparator 2

 Variable Type: Double

 Default:       0.0          Control Name:  Upper Limit2

 Description:   Specifies the upper limit of the
                two limit comparator 2

 Variable Type: Double

 Default:       0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   Invalid Comparator Datas   
n        `    Instrument ID                          `    Lower Limit1                     L     `    Upper Limit1                      m     `    Lower Limit2                     
 m    `    Upper Limit2                     Q     `    Error                              1    	           	           	           	           	            Z     Panel Name:    Peak Detection State

 Description:   Switches the peak detection ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the state is On the peak 
                detection is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   '        `    Instrument ID                    X m          State                                 `    Error                              1    On 1 Off 0    	            b     Panel Name:    Read Peak Detection State

 Description:   Reads the state of the peak detection    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the peak
                detection is activated

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   $        `    Instrument ID                    U m     `    State                                 `    Error                              1    	            	                 Panel Name:    Read Peak Values

 Description:   Reads the peak values
                values as double

                - Minium Value
                - Maximum Value
                - Difference Value    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     d     Control Name:  Min. Value

 Description:   Returns the minimum peak value

 Variable Type: double     t     Control Name:  Max. Value

 Description:   Returns the maximum peak value
                
 Variable Type: double          Control Name:  Diff. Value

 Description:   Returns the difference
                max. peak value - min. peak value

 Variable Type: double         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error           `    Instrument ID                      } n    `    Min. Value                       !) }     `    Max. Value                       ! }    `    Diff. Value                      "<     `    Error                              1    	           	           	           	            H     Panel Name:    Tare State

 Description:   Sets the Tare State ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On, the calibrate
                the input offset


 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   '        `    Instrument ID                    ( m          State                            )u     `    Error                              1    On 1 Off 0    	            U     Panel Name:    Read Tare State

 Description:   Read the sate of the tare function    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On, the calibrate
                the input offset


 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   -z        `    Instrument ID                    . m     `    State                            /h     `    Error                              1    	            	            Q     Panel Name:    Read Tare Values

 Description:   Read the tare value as double    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     z     Control Name:  Value

 Description:   Returns the tare value
                of the instrument.

 Variable Type: double         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error   3g        `    Instrument ID                    4 m     `    Tare Value                       5     `    Error                              1    	           	            U     Panel Name:    Start Measuring

 Description:   Start the measuring of instrument
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error   9        `    Instrument ID                    ;!     `    Error                              1    	                 Panel Name:    Read Measure Value

 Description:   Read the measurment value as
                double ,the unit and the
                comparator value    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     u     Control Name:  Value

 Description:   Returns the Value of the
                instrument.

 Variable Type: double     s     Control Name:  Unit

 Description:   Returns the Unit of the
                instrument.

 Variable Type: String          Control Name:  Comparator Value

 Description:   Returns the comparator value of
                the instrument.

 Variable Type: String

 Possible Values:  NC is equal No Comparator
                   <<, < , = , > , >>    +     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error

      350   Measuring not started   ?        `    Instrument ID                    A/ }     `    Value                            A }    `    Unit                             B' }    `    Comparator Value                 C     `    Error                              1    	           	            	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    +     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error

      350   Measuring not started     u     Control Name:  Value

 Description:   Returns the Value of the
                instrument.

 Variable Type: double     u     Control Name:  Value

 Description:   Returns the Value of the
                instrument.

 Variable Type: double   G        `    Instrument ID                    H    `    Error                            K      `    value                            L` ~4    `    comp_value                         1    	            	            	            C     Panel Name:    Stop Measuring

 Description:   Abort the measure    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error   N%        `    Instrument ID                    OV     `    Error                              1    	           f     Panel Name:    Set Serial Parameters


 Description:   Sets the followed Serial
                Communication Parameters
                - Interface Type
                - Baudrate
                - Group Address
                - User Address
                - Databits
                - Parity
                - Blockcheck
                - Char Delay

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    0     Control Name:  Interface Type

 Description:   Specifies the Interface Type of
                the communicate with the
                instrument.


 Variable Type: Integer

 Valid Range:   0 = RS232
                1 = RS485 Fullduplex
                1 = RS485 Halfduplex

 Default:       0 = RS232          Control Name:  Group Address

 Description:   Specifies the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.


 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0          Control Name:  User Adress

 Description:   Specifies the user address on the
                RS232 (RS485) to be used to
                communicate with the instrument.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0    s     Control Name:  Baudrate

 Description:   Specifies the Baudrate to
                communicate with the instrument.


 Variable Type: Integer

 Valid Range:   0 = 300
                1 = 600
                2 = 1200
                3 = 2400
                4 = 4800
                5 = 9600
                6 = 19200
                7 = 38400

 Default:       5 = 9600         Control Name:  DBits/Parity/SBits

 Description:   Specifies the Databits the Parity
                (0 = Off,1 = ON) and the Stopbits
                to communicate with the instrument


 Variable Type: Integer

 Valid Range:   0 = 8DataBits No Parity 1Stopbit
                1 = 7DataBits No Parity 2Stopbit
                2 = 7DataBits YesParity 1Stopbit
                3 = 8DataBits No Parity 2Stopbit
                4 = 8DataBits YesParity 1Stopbit

 Default:       0 = 8DataBits No Parity 1Stopbit
          Control Name:   Bcc-Check

 Description:    This parameter switches the block
                 check function of the instrument

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF          Control Name:  Char Delay

 Description:   Siwtch the Char Delay Function of
                the device ON


 Variable Type: Integer

 Valid Range:   0 to 1

                0 = off
                1 = on
         Control Name:  Parity

 Description:   Specifies the Databits the Parity
                Mode to communicate with
                the instrument.


 Variable Type: Integer

 Valid Range:   0 = None
                1 = ODD
                2 = EVEN

 Default:       0 = None
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Interface Type
       -2   Invalid Group Address
       -3   Invalid User Address
       -4   Invalid Baudrate
       -5   Invalid Databits
       -6   Invalid Parity
       -7   Invalid Blockcheck
       -8   Invalid Chardelay

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   T        `    Instrument ID                    V-          Interface Type                   We @     `    Group Address                    Xc      `    User Address                     Y] }         Baudrate                         Z }         DBits/Parity/SBits               \ }U          Block Check                      ] }          Char Delay                       ^          Parity                           _     `    Error                              1               &RS232 0 RS485(FullD) 1 RS485(HalfD) 2    0    0              8300 0 600 1 1200 2 2400 3 4800 4 9600 5 19200 6 38400 7               F8DA 0PA 1ST 0 7DA 0PA 2ST 1 7DA 1PA 1ST 2 8DA 0PA 2ST 3 8DA 1PA 1ST 4    On 1 Off 0    On 1 Off 0               
EVEN 0 ODD 1    	           i     Panel Name:    Read Serial Parameters


 Description:   Reads the following serial
                communication parameters
                - Interface Type
                - Baudrate
                - Group Address
                - User Address
                - Databits
                - Parity
                - Blockcheck
                - Char Delay

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    0     Control Name:  Interface Type

 Description:   Specifies the Interface Type of
                the communicate with the
                instrument.


 Variable Type: Integer

 Valid Range:   0 = RS232
                1 = RS485 Fullduplex
                1 = RS485 Halfduplex

 Default:       0 = RS232          Control Name:  Group Address

 Description:   Specifies the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.


 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0          Control Name:  User Adress

 Description:   Specifies the user address on the
                RS232 (RS485) to be used to
                communicate with the instrument.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0    s     Control Name:  Baudrate

 Description:   Specifies the Baudrate to
                communicate with the instrument.


 Variable Type: Integer

 Valid Range:   0 = 300
                1 = 600
                2 = 1200
                3 = 2400
                4 = 4800
                5 = 9600
                6 = 19200
                7 = 38400

 Default:       5 = 9600         Control Name:  DBits/Parity/SBits

 Description:   Specifies the Databits the Parity
                (0 = Off,1 = ON) and the Stopbits
                to communicate with the instrument


 Variable Type: Integer

 Valid Range:   0 = 8DataBits No Parity 1Stopbit
                1 = 7DataBits No Parity 2Stopbit
                2 = 7DataBits YesParity 1Stopbit
                3 = 8DataBits No Parity 2Stopbit
                4 = 8DataBits YesParity 1Stopbit

 Default:       0 = 8DataBits No Parity 1Stopbit
          Control Name:   Bcc-Check

 Description:    This parameter switches the block
                 check function of the instrument

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF          Control Name:  Char Delay

 Description:   Siwtch the Char Delay Function of
                the device ON


 Variable Type: Integer

 Valid Range:   0 to 1

                0 = off
                1 = on
         Control Name:  Parity

 Description:   Specifies the Databits the Parity
                Mode to communicate with
                the instrument.


 Variable Type: Integer

 Valid Range:   0 = None
                1 = ODD
                2 = EVEN

 Default:       0 = None
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Interface Type
       -2   Invalid Group Address
       -3   Invalid User Address
       -4   Invalid Baudrate
       -5   Invalid Databits
       -6   Invalid Parity
       -7   Invalid Blockcheck
       -8   Invalid Chardelay

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   h         `    Instrument ID                    i1      `    Interface Type                   ji @     `    Group Address                    kg      `    User Address                     la }     `    Baudrate                         m }     `    DBits/Parity/SBits               o }A     `    Block Check                      p }     `    Char Delay                       q      `    Parity                           r     `    Error                              1    	            	            	            	            	            	            	            	            	           H     Panel Name:    Accept New Serial Para.

 Description:   The new Serial Parameters
                are accepted.

 WARNING :      After this function the new serial
                Paramters are active.
                Now you must change the same
                Parameters by your Personal
                Computer Interface    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      330   The devicve don't accept the
            calibration datas   z0        `    Instrument ID                    {a     `    Error                              1    	                 Panel Name:    Store Memory No.

 Description:   Store the actual Parameters to
                the selected memory of the
                instrument
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Memory No.

 Description:    Specifies the Memory No.

 Variable Type:  integer

 Valid Range:    1 to 16

 Default:        1
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty           `    Instrument ID                          2    Memory No.                       ]     `    Error                              1               N1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13 14 14 15 15 16 16    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    +     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error

      350   Measuring not started   w #       `    Instrument ID                        `    Error                              1    	                 Panel Name:    Recall Memory No.

 Description:   Recall the actual Parameters to
                the selected memory of the
                instrument
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty          Control Name:   Memory No.

 Description:    Specifies the Memory No.

 Variable Type:  integer

 Valid Range:    1 to 16

 Default:        1
           `    Instrument ID                    *     `    Error                            7 w     2    Memory No.                         1    	                       N1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13 14 14 15 15 16 16    r     Panel Name:    Display Contrast

 Description:   Adjust the display contrast of the
                instrument
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Display Contrast

 Description:    Specifies the display contrast

 Variable Type:  Double

 Valid Range:    0.0 to 1.0

 Default:        0.5
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Contrast

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   W        `    Instrument ID                     m     `    Contrast                         1     `    Error                              1    0.5    	            v     Panel Name:    Read Display Contrast

 Description:   Reads the display contrast of the
                instrument
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Display Contrast

 Description:    Specifies the display contrast

 Variable Type:  Double

 Valid Range:    0.0 to 1.0

 Default:        0.5
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Contrast

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   q        `    Instrument ID                     m     `    Contrast                         K     `    Error                              1    	           	            a     Panel Name:   System Error

 Description:  Reads the system error of the
               device    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  System Error

 Description:   Displays the SCPI system error


 Variable Type: String
                (see manual Resistomat Type 6706)
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0     Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
   {        `    Instrument ID                     l     `    System Error                     N     `    Error                              1    	            	            U     Panel Name:   System Keybroad

 Description:  Controls the keybroad of the device
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Keyboard

 Description:   This parameter locks the keyboard
                on the front panel of the
                instrument

 Variable Type: Integer

 Valid Range:   0  = Unlocked
                1  = Locked         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Value

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                    " m           Keyboard                              `    Error                              1    Locked 1 Unlocked 0    	            n     Panel Name:   System Security

 Description:  Controls the security functions
               of the device
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Security Code

 Description:    Specifies the sequrity code of
                 the instrument

 Variable Type:  integer

 Variable Range: 0-9999


 Default:        2588         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Code

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                    ! m      2    Code                                  `    Error                              1    2588    	            [     Panel Name:   Read System Security

 Description:  Reads the security code of the device    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Security Code

 Description:    Specifies the sequrity code of
                 the instrument

 Variable Type:  integer

 Variable Range: 0-9999


 Default:        2588         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Code

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                     m      2    Code                                  `    Error                              1    	            	            c     Panel Name:   Send a SCPI-Message

 Description:  Sends a SCPI-Message to a
               slave    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input the SCPI-message
                without the LineFeed termination.

 Example      : ":SENS:CORR:STATE ON"

 Variable Type: String
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   `        `    Instrument ID                     }     `    Send-SCPI-Message                     `    Error                              1        	                 Panel Name:   Receive a SCPI-Message

 Description:  Sends "Query form" from SCPI-
               Message and receive a answers
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input Query-Form from
                the SCPI-message without the
                Line Feed termination.

 Example      : ":SENS:CORR:STATE?"

 Variable Type: String          Control Name:  Answer from Slave

 Description:   This control return a string from
                the slave.

 Variable Type: String (Length => see the 6706
                        Manual SCPI-Commands)         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT   Z        `    Instrument ID                     }     `    Send-SCPI-Message                 }G    `    Instrument Answers                    `    Error                              1        	            	            H     Panel Name:    Tare State

 Description:   Sets the Tare State ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On, the calibrate
                the input offset


 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   M        `    Instrument ID                    ~ j          Datenlogger                      ;     `    Error                              1    On 1 Off 0    	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   ?        `    Instrument ID                    p m     `    Data logger state                %     `    Error                              1    	            	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   '        `    Instrument ID                    X ~          Block                            
     `    Error                              1                        	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                    K j         Block                                  `    Error                              1                          	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   
        `    Instrument ID                    > m     `    Selected Block                        `    Error                              1    	            	            T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument_ID                    & z8     `    Count                                 `    Error                            {          Block                              1    	            	                                 T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   )        `    Instrument ID                    Z {    `    Value                                 `    Error                            {         Number                           z v         Block                              1    	           	                                                   T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                        `    Error                            j          Size                             k          Block                            m
    `    Name                              _         Filter                                     XVal                                     Time                                `    Delta                              1    	              '                                                        6All 0 In Order 1 Not in Order 2 XVal 3 Time 4 Delta 5                  ?            ?PbM?                   0.0    T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                        `    Error                            j     `    Size                             i          Block                            m
    `    Name                                  `    Filter                                `    XVal                             	   `    Time                                `    Delta                              1    	            	                                  	            	            	            	           	           T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On          Control Name:  State

 Description:   If the State is On the comparator
                is active

 Variable Type: Integer

 Valid Range:   0 = Off
                1 = On    X       `    Instrument ID                     [     `    Minimum                          x    `    Error                            b W    `    Std. Deviation                    \V    `    Maximum                                `    Mean Value                                 Block                              1    	           	            	           	           	                                 T     Panel Name:    Read Comparator State

 Description:   Reads the Comparator State     )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

           `    Instrument ID                         `    Error                                 `    Data                                       Block                                      Adresse                            1    	            	                                    &                       Panel Name:    Close

 Description:   Takes the instrument off-line.

 Note: The  instrument must  be reinitialized
       to use it again.    *     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.
         Control Name:  Error


 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      221   Unable to close instrument
      232   Instrument not initialized           `    Instrument ID                    	     `    Error                              1    	                  	           
    K.        init_device                                                                                                                                      V  ,{         	    K.        init_all_devices                                                                                                                                 /  3/             K.        init_rs485                                                                                                                                       4  9O             K.        cal_state                                                                                                                                        :
  ?O             K.        read_cal_state                                                                                                                                   @  E@             K.        cal_set_unit                                                                                                                                     E  K6             K.        read_cal_unit                                                                                                                                    K  S@             K.        cal_input                                                                                                                                        T  \             K.        read_cal_input                                                                                                                                   ]  c             K.        cal_analogue_output                                                                                                                              e7  k             K.        read_cal_analogue_output                                                                                                                         m  r             K.        cal_input_meas                                                                                                                                   sN  x             K.        read_cal_input_meas                                                                                                                              y  ~             K.        cal_accept_datas                                                                                                                                 v  <             K.        config                                                                                                                                                          K.        read_config                                                                                                                                                     K.        config_output                                                                                                                                      %             K.        read_config_output                                                                                                                               "               K.        config_analog_output                                                                                                                               C             K.        read_config_analog_output                                                                                                                                       K.        config_input                                                                                                                                     ũ               K.        read_config_input                                                                                                                                	  5             K.        comp_state                                                                                                                                                      K.        read_comp_state                                                                                                                                                 K.        read_comp_count                                                                                                                                                 K.        comp_config                                                                                                                                      
  &             K.        read_comp_config                                                                                                                                 #               K.        comp_two_limit                                                                                                                                   
               K.        read_comp_two_limit                                                                                                                              o             K.        comp_four_limit                                                                                                                                 	 F             K.        read_comp_four_limit                                                                                                                                          K.        peak_detection_state                                                                                                                                          K.        read_peak_detection_state                                                                                                                        %             K.        read_peak_values                                                                                                                                '7 ,_             K.        tare_state                                                                                                                                      - 2R             K.        read_tare_state                                                                                                                                 3 8             K.        read_tare_value                                                                                                                                 9 >             K.        start_measure                                                                                                                                   ?Z FA             K.        read_measure                                                                                                                                    L             K.        read_string_measure                                                                                                                             M S             K.        stop_measure                                                                                                                                    S cY         
    K.        system_serial_set_para                                                                                                                          f v]         
    K.        read_system_serial_para                                                                                                                         x ~w             K.        system_serial_accept                                                                                                                            ~ j             K.        store_memory                                                                                                                                                 K.        get_status                                                                                                                                      V              K.        recall_memory                                                                                                                                    <             K.        set_display_contrast                                                                                                                             V             K.        read_display_contrast                                                                                                                                         K.        system_error                                                                                                                                                  K.        system_keyboard                                                                                                                                 z              K.        system_security                                                                                                                                 ? 9             K.        read_system_security                                                                                                                                          K.        send_scpi                                                                                                                                                     K.        receive_scpi                                                                                                                                     %             K.        logg_state                                                                                                                                                    K.        read_logg_state                                                                                                                                               K.        clear_block                                                                                                                                     Ҿ              K.        select_block                                                                                                                                    ر              K.        read_selected_block                                                                                                                             ޙ              K.        read_count                                                                                                                                                    K.        read_data                                                                                                                                       M          	    K.        set_block_parameter                                                                                                                             r          	    K.        read_block_parameter                                                                                                                            6               K.        read_eval                                                                                                                                       L              K.        read_data_block                                                                                                                                  
             K.        close                                                                                                                                                                                                                              Initialize                                                                           Initialize One Device                                                                Initialize All Devices                                                               Init. RS485 (CVI only)                                                              Calibrate                                                                            Calibration State                                                                    Read Calibration State                                                               Sets Calibration Unit                                                                Read Calibration Unit                                                                Calibration Input                                                                    Read Calibration Input                                                               Calibration Ana. Output                                                              Read Calibration Ana. Output                                                         Calibration Input Meas.                                                              Read Calibration Input Meas.                                                         Accept Calibration Datas                                                            3Configure                                                                            Config Device                                                                        Read Config Device                                                                   Config Output                                                                        Read Config Output                                                                   Config Analog Output                                                                 Read Config Analog Output                                                            Config Input                                                                         Read Config Input                                                                   Comparator                                                                           Comparator State                                                                     Read Comparator State                                                                Read_comp_count                                                                      Comparator Config                                                                    Read Comparator Config                                                               Two Limit Comparator                                                                 Read Two Limit Comparator                                                            Four Limit Comparator                                                                Read Four Limit Comparator                                                          /Peak Detection                                                                       Peak Detection State                                                                 Read Peak Detection State                                                            Read Peak Values                                                                    Tare                                                                                 Tare State                                                                           Read Tare State                                                                      Read Tare Value                                                                     Measuring                                                                            Start Measure                                                                        Read Measure Value                                                                   Read Measure String                                                                  Stop Measure                                                                        System Serial Comm.                                                                  Set Serial Parameters                                                                Read Serial Parameters                                                               Accept New Serial Para                                                              	LSystem                                                                               Store Memory No.                                                                     Get Status                                                                           Recall Memory No.                                                                    Set Display Contrast                                                                 Read Display Contrast                                                                System Error                                                                         System Keyboard                                                                      System Security                                                                      Read System Security                                                                 Send a SCPI-Message                                                                  Receive a SCPI-Message                                                            Datalogger                                                                           Logg state                                                                           Read Logg State                                                                      Clear Block                                                                          Select Block                                                                         Read Selected Block                                                                  Read Count                                                                           Read Data                                                                            Set Block Parameter                                                                  Read Block Parameter                                                                 Read Eval                                                                            Read Data Block                                                                      Close                                                                           